// ==UserScript==
// @name           Youtube userpage to videos
// @namespace      http://mummila.net
// @description    Rewrites links pointing to Youtube userpage to point to their videos listing
// @version        1.0
// @author         Jani Uusitalo
// @include      http://*
// @include      https://*
// @exclude     http://www.youtube.com/channel/*/videos
// @exclude     https://www.youtube.com/channel/*/videos
// @exclude     http://www.youtube.com/user/*/videos
// @exclude     https://www.youtube.com/user/*/videos
// ==/UserScript==

function jani_fixYoutube(url) {
	var re = /^(.*).sub_confirmation=1$/i;
    var h;
    if (h = re.exec(url)) {
        url = h[1];
        return url;
    }
    re = /subscription_center\?add_user=(.*)$/i;
    if (h = re.exec(url)) {
        url = "https://www.youtube.com/user/" + h[1];
        return url;
    }
    re = /^(https?:\/\/www.youtube.com\/)(channel|user)(\/[^\/\?]*)(|\?.*)$/;
    if (h = re.exec(url)) {
        url = h[1] + h[2] + h[3] + "/videos" + h[4];
        return url;
    }
    /* numero on G+-profiilin joten tämä paska ei toimi.
    re = /^(https?:\/\/www.youtube.com\/)(profile_redirector\/)([^\/\?]*)(|\?.*)$/;
    if (h = re.exec(url)) {
        url = h[1] + "channel/" + h[3] + "/videos" + h[4];
        return url;
    }
    */
    re = /^(https?:\/\/www.youtube.com\/)(?!account.*|watch|upload|enhance|my_videos|dashboard|edit|pair|playlist)([^\/]*)$/;
    if (h = re.exec(url)) {
        url = h[1] + h[2] + "/videos";
        return url;
    }
    return url;
}

(function (){
	var i, url;
	a = window.document.getElementsByTagName("a");
	for (i = 0; i < a.length; i += 1) {
        url = jani_fixYoutube(a[i].href);
        if (url !== a[i].href) {
            a[i].href = url;
            url = jani_fixYoutube(a[i].innerHTML);
            a[i].innerHTML = url;
            console.log("replace");
        }
	}
}());
